bl_info = {
    "name": "Shader Switcher Node",
    "author": "Aimen Zaied",
    "version": (4, 0, 2),
    "blender": (4, 5, 0),
    "location": "Node Editor > Add > Shader Switcher",
    "description": "Switch, Mix, Randomize shaders and colors — plus Master Material routing by Object Pass Index.",
    "category": "Node",
}

import bpy
from . import operators, ui

def register():
    operators.register()
    ui.register()

    # Pointer properties (after classes are registered)
    bpy.types.NodeTree.shader_switcher_props = bpy.props.PointerProperty(
        type=operators.ShaderSwitcherProps
    )
    bpy.types.Scene.shader_switcher_addon_props = bpy.props.PointerProperty(
        type=operators.ShaderSwitcherAddonProps
    )

    # Add menu entry
    bpy.types.NODE_MT_add.append(ui.shader_switcher_menu)
    print("Shader Switcher Extension Registered.")

def unregister():
    # Remove menu
    try:
        bpy.types.NODE_MT_add.remove(ui.shader_switcher_menu)
    except Exception:
        pass

    # Remove pointer props
    if hasattr(bpy.types.NodeTree, "shader_switcher_props"):
        del bpy.types.NodeTree.shader_switcher_props
    if hasattr(bpy.types.Scene, "shader_switcher_addon_props"):
        del bpy.types.Scene.shader_switcher_addon_props

    ui.unregister()
    operators.unregister()
    print("Shader Switcher Extension Unregistered.")

if __name__ == "__main__":
    register()
